from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from PassiveAffinityType import PassiveAffinityType
from ActiveAffinityType import ActiveAffinityType
from GenericServerClusterTimeMapping import GenericServerClusterTimeMapping

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericServerClusterRoute')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericServerClusterRoute");
  exportedObject.put("roleName", "WebSphereGenericServerClusterRoute");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverclusterroute.genericserverclustername", objid, "genericServerClusterName","GenericServerClusterRoute");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  affinityType = Util.getRequiredAttribute(objid, 'affinityType',"GenericServerClusterRoute");
  if affinityType is not None and len(affinityType) > 0:
    if affinityType.find("#ActiveAffinityType_") != -1:
      returndict = Util.createTypeFolder(respath, "ActiveAffinityType", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ActiveAffinityType._export(affinityType, currespath, 'Active Affinity Type'));
    elif affinityType.find("#PassiveAffinityType_") != -1:
      returndict = Util.createTypeFolder(respath, "PassiveAffinityType", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, PassiveAffinityType._export(affinityType, currespath, 'Passive Affinity Type'));

  i = 0;
  genericServerClusterTimeMappings = Util.parseConfigIdListAttribute(objid, 'genericServerClusterTimeMappings',"GenericServerClusterRoute");
  for genericServerClusterTimeMapping in genericServerClusterTimeMappings:
    if len(genericServerClusterTimeMapping) > 0:
      returndict = Util.createTypeFolder(respath, "GenericServerClusterTimeMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, GenericServerClusterTimeMapping._export(genericServerClusterTimeMapping, currespath, "Generic Server Cluster Time Mapping%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericServerClusterRoute');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericServerClusterRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "genericServerClusterName", roleProperties.optString("websphere.genericserverclusterroute.genericserverclustername", None));
  print "Creating GenericServerClusterRoute with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericServerClusterRoute", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereActiveAffinityType":
        ActiveAffinityType.create(objid, curjsonobject);
      elif currole == "WebSpherePassiveAffinityType":
        PassiveAffinityType.create(objid, curjsonobject);
      elif currole == "WebSphereGenericServerClusterTimeMapping":
        GenericServerClusterTimeMapping.create(objid, curjsonobject);
  Util.popPathElement('GenericServerClusterRoute');

def update(objid,jsonobject):
  Util.pushPathElement('GenericServerClusterRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverclusterroute.genericserverclustername", None), "genericServerClusterName","GenericServerClusterRoute");
  if len(atts) != 0:
    print "Modifying GenericServerClusterRoute with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericServerClusterRoute configuration up to date.";

  affinityType = Util.getRequiredAttribute(objid, 'affinityType',"GenericServerClusterRoute");
  if affinityType is not None and len(affinityType) > 0:
    Util.remove(affinityType);

  genericServerClusterTimeMappings = Util.parseConfigIdListAttribute(objid, 'genericServerClusterTimeMappings',"GenericServerClusterRoute");
  for genericServerClusterTimeMapping in genericServerClusterTimeMappings:
    if len(genericServerClusterTimeMapping) > 0:
      Util.remove(genericServerClusterTimeMapping);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereActiveAffinityType":
        ActiveAffinityType.create(objid, curjsonobject);
      elif currole == "WebSpherePassiveAffinityType":
        PassiveAffinityType.create(objid, curjsonobject);
      elif currole == "WebSphereGenericServerClusterTimeMapping":
        GenericServerClusterTimeMapping.create(objid, curjsonobject);

  Util.popPathElement('GenericServerClusterRoute');
