#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ActivationSpec import ActivationSpec

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageListener')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageListener");
  exportedObject.put("roleName", "WebSphereMessageListener");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistener.messagelistenertype", objid, "messageListenerType","MessageListener");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  actSpec = Util.getOptionalAttribute(objid, 'activationSpec', 'MessageListener');
  if actSpec is not None and len(actSpec) > 0:
    returndict = Util.createTypeFolder(respath, "ActivationSpec", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ActivationSpec._export(actSpec, currespath, "Activation Spec"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageListener');
  return result;


def create(parentid, jsonobject):
  Util.pushPathElement('MessageListener')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageListener resource has no role properties!");
  roleProperties = jsonobject.getJSONObject("roleProperties");
  properties = [];
  Util.addIfNotNone(properties, "messageListenerType", roleProperties.optString("websphere.messagelistener.messagelistenertype", None));
  print "Creating MessageListener with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageListener", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereActivationSpec":
        ActivationSpec.create(objid, curjsonobject);
  Util.popPathElement('MessageListener');

def update(objid,jsonobject):
  Util.pushPathElement('MessageListener')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageListener resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistener.messagelistenertype", None), "messageListenerType","MessageListener");
  if len(atts) != 0:
    print "Modifying MessageListener with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageListener configuration up to date.";

  actSpec = Util.getOptionalAttribute(objid, 'activationSpec', 'MessageListener');
  if actSpec is not None and len(actSpec) > 0:
    Util.remove(actSpec);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereActivationSpec":
        ActivationSpec.create(objid, curjsonobject);
  Util.popPathElement('MessageListener');
