from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from Service import Service
from Component import Component
from EndPoint import EndPoint
from utilities import Util
from StateManageable import StateManageable

__name_att__ = "websphere.cellmanager.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CellManager')

  if len(name) == 0:
    name = Util.getRequiredAttribute(objid, "name", 'CellManager');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCellManager");
  exportedObject.put("roleName", "WebSphereCellManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cellmanager.name", objid, "name","CellManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  celldiscoveryaddress = Util.getOptionalAttribute(objid, 'CELL_DISCOVERY_ADDRESS', "CellManager");
  cellmulticastdiscoveryaddress = Util.getOptionalAttribute(objid, 'CELL_MULTICAST_DISCOVERY_ADDRESS', "CellManager");
  if (celldiscoveryaddress != None or celldiscoveryaddress != None):
    returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
  if (celldiscoveryaddress != None):
    Util.addAllFromExport(extraObjects, EndPoint._export(celldiscoveryaddress, currespath, "CELL_DISCOVERY_ADDRESS"));
  if (cellmulticastdiscoveryaddress != None):
    Util.addAllFromExport(extraObjects, EndPoint._export(cellmulticastdiscoveryaddress, currespath, "CELL_MULTICAST_DISCOVERY_ADDRESS"));

  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "CellManager");

  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "CellManager");

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AdminService");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"CellManager");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CellManager');
  return result;




def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CellManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("CellManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.cellmanager.name"):
    raise Exception("Resource role properties does not contain websphere.cellmanager.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.cellmanager.name", None));
  print "Creating CellManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CellManager", parentid, properties);

  Component.removeComponents(objid, 'components', "CellManager");
  Service.removeServices(objid, 'services', "CellManager");
  Property.removeProperties(objid, 'properties',"CellManager");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"CellManager");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
          elif currole == "WebSphereEndPoint":
           name = curjsonobject.getString('name');
           if name == "CELL_DISCOVERY_ADDRESS":
             oep = Util.getRequiredAttribute(objid, "CELL_DISCOVERY_ADDRESS", "CellManager");
             EndPoint.update(oep, curjsonobject);
           elif name == "CELL_MULTICAST_DISCOVERY_ADDRESS":
             oep = Util.getRequiredAttribute(objid, "CELL_MULTICAST_DISCOVERY_ADDRESS", "CellManager");
             EndPoint.update(oep, curjsonobject);
           else:
             print ("Warning: Attempted to update WebSphereEndPoint but could not find one named " +
             "CELL_DISCOVERY_ADDRESS or CELL_MULTICAST_DISCOVERY_ADDRESS.  Found one with name " + name + ".");
  Util.popPathElement('CellManager');
  return objid;

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CellManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("CellManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.cellmanager.name"):
    raise Exception("Resource role properties does not contain websphere.cellmanager.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cellmanager.name", None), "name","CellManager");
  if len(atts) != 0:
    print "Modifying CellManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CellManager configuration up to date.";

  Component.removeComponents(objid, 'components', "CellManager");
  Service.removeServices(objid, 'services', "CellManager");
  Property.removeProperties(objid, 'properties',"CellManager");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"CellManager");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);        
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);                
          elif currole == "WebSphereEndPoint":
           name = curjsonobject.getString('name');
           if name == "CELL_DISCOVERY_ADDRESS":
             oep = Util.getRequiredAttribute(objid, "CELL_DISCOVERY_ADDRESS", "CellManager");
             EndPoint.update(oep, curjsonobject);
           elif name == "CELL_MULTICAST_DISCOVERY_ADDRESS":
             oep = Util.getRequiredAttribute(objid, "CELL_MULTICAST_DISCOVERY_ADDRESS", "CellManager");
             EndPoint.update(oep, curjsonobject);
           else:
             print ("Warning: Attempted to update WebSphereEndPoint but could not find one named " +
             "CELL_DISCOVERY_ADDRESS or CELL_MULTICAST_DISCOVERY_ADDRESS.  Found one with name " + name + ".");
  Util.popPathElement('CellManager');
  return objid;
