from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CoreGroupBridgeService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCoreGroupBridgeService");
  exportedObject.put("roleName", "WebSphereCoreGroupBridgeService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupbridgeservice.enablebridge", objid, "enableBridge","CoreGroupBridgeService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupbridgeservice.enable", objid, "enable","CoreGroupBridgeService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CoreGroupBridgeService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CoreGroupBridgeService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CoreGroupBridgeService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupBridgeService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableBridge", roleProperties.optString("websphere.coregroupbridgeservice.enablebridge", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.coregroupbridgeservice.enable", None));
  print "Creating CoreGroupBridgeService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CoreGroupBridgeService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupBridgeService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CoreGroupBridgeService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupBridgeService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupbridgeservice.enablebridge", None), "enableBridge","CoreGroupBridgeService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupbridgeservice.enable", None), "enable","CoreGroupBridgeService");
  if len(atts) != 0:
    print "Modifying CoreGroupBridgeService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CoreGroupBridgeService configuration up to date.";

  Property.removeProperties(objid, 'properties',"CoreGroupBridgeService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupBridgeService');
