from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HPELLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHPELLog");
  exportedObject.put("roleName", "WebSphereHPELLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.outofspaceaction", objid, "outOfSpaceAction","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.bufferingenabled", objid, "bufferingEnabled","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.purgemaxsize", objid, "purgeMaxSize","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.datadirectory", objid, "dataDirectory","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.fileswitchenabled", objid, "fileSwitchEnabled","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.purgemintime", objid, "purgeMinTime","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.fileswitchtime", objid, "fileSwitchTime","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.purgebysizeenabled", objid, "purgeBySizeEnabled","HPELLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpellog.purgebytimeenabled", objid, "purgeByTimeEnabled","HPELLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HPELLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HPELLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outOfSpaceAction", roleProperties.optString("websphere.hpellog.outofspaceaction", None));
  Util.addIfNotNone(properties, "bufferingEnabled", roleProperties.optString("websphere.hpellog.bufferingenabled", None));
  Util.addIfNotNone(properties, "purgeMaxSize", roleProperties.optString("websphere.hpellog.purgemaxsize", None));
  Util.addIfNotNone(properties, "dataDirectory", roleProperties.optString("websphere.hpellog.datadirectory", None));
  Util.addIfNotNone(properties, "fileSwitchEnabled", roleProperties.optString("websphere.hpellog.fileswitchenabled", None));
  Util.addIfNotNone(properties, "purgeMinTime", roleProperties.optString("websphere.hpellog.purgemintime", None));
  Util.addIfNotNone(properties, "fileSwitchTime", roleProperties.optString("websphere.hpellog.fileswitchtime", None));
  Util.addIfNotNone(properties, "purgeBySizeEnabled", roleProperties.optString("websphere.hpellog.purgebysizeenabled", None));
  Util.addIfNotNone(properties, "purgeByTimeEnabled", roleProperties.optString("websphere.hpellog.purgebytimeenabled", None));
  print "Creating HPELLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HPELLog", parentid, properties);
  Util.popPathElement('HPELLog');

def update(objid,jsonobject):
  Util.pushPathElement('HPELLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.outofspaceaction", None), "outOfSpaceAction","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.bufferingenabled", None), "bufferingEnabled","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.purgemaxsize", None), "purgeMaxSize","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.datadirectory", None), "dataDirectory","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.fileswitchenabled", None), "fileSwitchEnabled","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.purgemintime", None), "purgeMinTime","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.fileswitchtime", None), "fileSwitchTime","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.purgebysizeenabled", None), "purgeBySizeEnabled","HPELLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpellog.purgebytimeenabled", None), "purgeByTimeEnabled","HPELLog");
  if len(atts) != 0:
    print "Modifying HPELLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HPELLog configuration up to date.";

  Util.popPathElement('HPELLog');
