from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HealthCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHealthCondition");
  exportedObject.put("roleName", "WebSphereHealthCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthcondition.name", objid, "name","HealthCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthcondition.conditionexpr", objid, "conditionExpr","HealthCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HealthCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HealthCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.healthcondition.name", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.healthcondition.conditionexpr", None));
  print "Creating HealthCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HealthCondition", parentid, properties);
  Util.popPathElement('HealthCondition');

def update(objid,jsonobject):
  Util.pushPathElement('HealthCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthcondition.name", None), "name","HealthCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthcondition.conditionexpr", None), "conditionExpr","HealthCondition");
  if len(atts) != 0:
    print "Modifying HealthCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HealthCondition configuration up to date.";

  Util.popPathElement('HealthCondition');
