from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JAXRPCHandlerList')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAXRPCHandlerList");
  exportedObject.put("roleName", "WebSphereJAXRPCHandlerList");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxrpchandlerlist.name", objid, "name","JAXRPCHandlerList");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.jaxrpchandlerlist.handlername", objid, "handlerName","JAXRPCHandlerList");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaxrpchandlerlist.description", objid, "description","JAXRPCHandlerList");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAXRPCHandlerList');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAXRPCHandlerList')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXRPCHandlerList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jaxrpchandlerlist.name", None));
  Util.addPathProperty(properties, "handlerName", roleProperties.optString("websphere.jaxrpchandlerlist.handlername", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jaxrpchandlerlist.description", None));
  print "Creating JAXRPCHandlerList with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAXRPCHandlerList", parentid, properties);
  Util.popPathElement('JAXRPCHandlerList');

def update(objid,jsonobject):
  Util.pushPathElement('JAXRPCHandlerList')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAXRPCHandlerList resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxrpchandlerlist.name", None), "name","JAXRPCHandlerList");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxrpchandlerlist.handlername", None), "handlerName","JAXRPCHandlerList");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaxrpchandlerlist.description", None), "description","JAXRPCHandlerList");
  if len(atts) != 0:
    print "Modifying JAXRPCHandlerList with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAXRPCHandlerList configuration up to date.";

  Util.popPathElement('JAXRPCHandlerList');
