#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ConnectionPool import ConnectionPool
from Property import Property
from MappingModule import MappingModule

__name_att__ = "websphere.mqqueueconnectionfactory.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MQQueueConnectionFactory');

  containmentpath = "%(parentconpath)sMQQueueConnectionFactory:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MQQueueConnectionFactory')

  name = Util.getRequiredAttribute(objid, "name", 'MQQueueConnectionFactory');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMQQueueConnectionFactory");
  exportedObject.put("roleName", "WebSphereMQQueueConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.wmqserversvrconnchannel", objid, "wmqServerSvrconnChannel","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.diagnoseconnectionusage", objid, "diagnoseConnectionUsage","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.ccsid", objid, "CCSID","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.rcvexit", objid, "rcvExit","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.wmqservername", objid, "wmqServerName","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sslconfiguration", objid, "sslConfiguration","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.host", objid, "host","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.category", objid, "category","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.tempmodel", objid, "tempModel","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.replywithrfh2", objid, "replyWithRFH2","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.inheritrrscontext", objid, "inheritRRSContext","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.secexit", objid, "secExit","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.name", objid, "name","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.xarecoveryauthalias", objid, "xaRecoveryAuthAlias","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.description", objid, "description","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.useconnectionpooling", objid, "useConnectionPooling","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.managecachedhandles", objid, "manageCachedHandles","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.wmqserverendpoint", objid, "wmqServerEndpoint","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.ccdturl", objid, "ccdtUrl","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.providerversion", objid, "providerVersion","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sslresetcount", objid, "sslResetCount","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.secexitinitdata", objid, "secExitInitData","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.pollinginterval", objid, "pollingInterval","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.msgretention", objid, "msgRetention","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.queuemanager", objid, "queueManager","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.jndiname", objid, "jndiName","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sendexit", objid, "sendExit","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.clientreconnectoptions", objid, "clientReconnectOptions","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.authmechanismpreference", objid, "authMechanismPreference","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sendexitinitdata", objid, "sendExitInitData","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.maxbatchsize", objid, "maxBatchSize","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.tempqueueprefix", objid, "tempQueuePrefix","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.xaenabled", objid, "XAEnabled","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.providertype", objid, "providerType","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.rcvexitinitdata", objid, "rcvExitInitData","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.channel", objid, "channel","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.port", objid, "port","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.authdataalias", objid, "authDataAlias","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sslpeername", objid, "sslPeerName","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.rescaninterval", objid, "rescanInterval","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.compressheaders", objid, "compressHeaders","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.failifquiesce", objid, "failIfQuiesce","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.clientid", objid, "clientID","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.localaddress", objid, "localAddress","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sslcrl", objid, "sslCRL","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.connamelist", objid, "connameList","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.logmissingtransactioncontext", objid, "logMissingTransactionContext","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.transporttype", objid, "transportType","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.sslciphersuite", objid, "sslCipherSuite","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.compresspayload", objid, "compressPayload","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.qmgrtype", objid, "qmgrType","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.ssltype", objid, "sslType","MQQueueConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mqqueueconnectionfactory.clientreconnecttimeout", objid, "clientReconnectTimeout","MQQueueConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MQQueueConnectionFactory");

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQQueueConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(connPool, currespath, 'ConnectionPool'));

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQQueueConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    returndict = Util.createTypeFolder(respath, "ConnectionPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ConnectionPool._export(sessPool, currespath, 'SessionPool'));

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQQueueConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    returndict = Util.createTypeFolder(respath, "MappingModule", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MappingModule._export(mapping, currespath, 'MappingModule'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MQQueueConnectionFactory');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueueConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mqqueueconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueueconnectionfactory.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MQQueueConnectionFactory on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MQQueueConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueueConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqqueueconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueueconnectionfactory.name!");

  properties = [];
  Util.addIfNotNone(properties, "wmqServerSvrconnChannel", roleProperties.optString("websphere.mqqueueconnectionfactory.wmqserversvrconnchannel", None));
  Util.addIfNotNone(properties, "diagnoseConnectionUsage", roleProperties.optString("websphere.mqqueueconnectionfactory.diagnoseconnectionusage", None));
  Util.addIfNotNone(properties, "CCSID", roleProperties.optString("websphere.mqqueueconnectionfactory.ccsid", None));
  Util.addIfNotNone(properties, "rcvExit", roleProperties.optString("websphere.mqqueueconnectionfactory.rcvexit", None));
  Util.addIfNotNone(properties, "wmqServerName", roleProperties.optString("websphere.mqqueueconnectionfactory.wmqservername", None));
  Util.addIfNotNone(properties, "sslConfiguration", roleProperties.optString("websphere.mqqueueconnectionfactory.sslconfiguration", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.mqqueueconnectionfactory.host", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.mqqueueconnectionfactory.category", None));
  Util.addIfNotNone(properties, "tempModel", roleProperties.optString("websphere.mqqueueconnectionfactory.tempmodel", None));
  Util.addIfNotNone(properties, "replyWithRFH2", roleProperties.optString("websphere.mqqueueconnectionfactory.replywithrfh2", None));
  Util.addIfNotNone(properties, "inheritRRSContext", roleProperties.optString("websphere.mqqueueconnectionfactory.inheritrrscontext", "false"));
  Util.addIfNotNone(properties, "secExit", roleProperties.optString("websphere.mqqueueconnectionfactory.secexit", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mqqueueconnectionfactory.name", None));
  Util.addIfNotNone(properties, "xaRecoveryAuthAlias", roleProperties.optString("websphere.mqqueueconnectionfactory.xarecoveryauthalias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mqqueueconnectionfactory.description", None));
  Util.addIfNotNone(properties, "useConnectionPooling", roleProperties.optString("websphere.mqqueueconnectionfactory.useconnectionpooling", None));
  Util.addIfNotNone(properties, "manageCachedHandles", roleProperties.optString("websphere.mqqueueconnectionfactory.managecachedhandles", None));
  Util.addIfNotNone(properties, "wmqServerEndpoint", roleProperties.optString("websphere.mqqueueconnectionfactory.wmqserverendpoint", None));
  Util.addIfNotNone(properties, "ccdtUrl", roleProperties.optString("websphere.mqqueueconnectionfactory.ccdturl", None));
  Util.addIfNotNone(properties, "providerVersion", roleProperties.optString("websphere.mqqueueconnectionfactory.providerversion", None));
  Util.addIfNotNone(properties, "sslResetCount", roleProperties.optString("websphere.mqqueueconnectionfactory.sslresetcount", None));
  Util.addIfNotNone(properties, "secExitInitData", roleProperties.optString("websphere.mqqueueconnectionfactory.secexitinitdata", None));
  Util.addIfNotNone(properties, "pollingInterval", roleProperties.optString("websphere.mqqueueconnectionfactory.pollinginterval", None));
  Util.addIfNotNone(properties, "msgRetention", roleProperties.optString("websphere.mqqueueconnectionfactory.msgretention", None));
  Util.addIfNotNone(properties, "queueManager", roleProperties.optString("websphere.mqqueueconnectionfactory.queuemanager", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.mqqueueconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "sendExit", roleProperties.optString("websphere.mqqueueconnectionfactory.sendexit", None));
  Util.addIfNotNone(properties, "clientReconnectOptions", roleProperties.optString("websphere.mqqueueconnectionfactory.clientreconnectoptions", "DISABLED"));
  Util.addIfNotNone(properties, "authMechanismPreference", roleProperties.optString("websphere.mqqueueconnectionfactory.authmechanismpreference", None));
  Util.addIfNotNone(properties, "sendExitInitData", roleProperties.optString("websphere.mqqueueconnectionfactory.sendexitinitdata", None));
  Util.addIfNotNone(properties, "maxBatchSize", roleProperties.optString("websphere.mqqueueconnectionfactory.maxbatchsize", None));
  Util.addIfNotNone(properties, "tempQueuePrefix", roleProperties.optString("websphere.mqqueueconnectionfactory.tempqueueprefix", None));
  Util.addIfNotNone(properties, "XAEnabled", roleProperties.optString("websphere.mqqueueconnectionfactory.xaenabled", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mqqueueconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "rcvExitInitData", roleProperties.optString("websphere.mqqueueconnectionfactory.rcvexitinitdata", None));
  Util.addIfNotNone(properties, "channel", roleProperties.optString("websphere.mqqueueconnectionfactory.channel", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.mqqueueconnectionfactory.port", None));
  Util.addIfNotNone(properties, "authDataAlias", roleProperties.optString("websphere.mqqueueconnectionfactory.authdataalias", None));
  Util.addIfNotNone(properties, "sslPeerName", roleProperties.optString("websphere.mqqueueconnectionfactory.sslpeername", None));
  Util.addIfNotNone(properties, "rescanInterval", roleProperties.optString("websphere.mqqueueconnectionfactory.rescaninterval", None));
  Util.addIfNotNone(properties, "compressHeaders", roleProperties.optString("websphere.mqqueueconnectionfactory.compressheaders", None));
  Util.addIfNotNone(properties, "failIfQuiesce", roleProperties.optString("websphere.mqqueueconnectionfactory.failifquiesce", None));
  Util.addIfNotNone(properties, "clientID", roleProperties.optString("websphere.mqqueueconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "localAddress", roleProperties.optString("websphere.mqqueueconnectionfactory.localaddress", None));
  Util.addIfNotNone(properties, "sslCRL", roleProperties.optString("websphere.mqqueueconnectionfactory.sslcrl", None));
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqqueueconnectionfactory.connamelist"):
    Util.addIfNotNone(properties, "connameList", roleProperties.optString("websphere.mqqueueconnectionfactory.connamelist", ""));
  Util.addIfNotNone(properties, "logMissingTransactionContext", roleProperties.optString("websphere.mqqueueconnectionfactory.logmissingtransactioncontext", None));
  Util.addIfNotNone(properties, "transportType", roleProperties.optString("websphere.mqqueueconnectionfactory.transporttype", None));
  Util.addIfNotNone(properties, "sslCipherSuite", roleProperties.optString("websphere.mqqueueconnectionfactory.sslciphersuite", None));
  Util.addIfNotNone(properties, "compressPayload", roleProperties.optString("websphere.mqqueueconnectionfactory.compresspayload", None));
  Util.addIfNotNone(properties, "qmgrType", roleProperties.optString("websphere.mqqueueconnectionfactory.qmgrtype", None));
  Util.addIfNotNone(properties, "sslType", roleProperties.optString("websphere.mqqueueconnectionfactory.ssltype", None));
  Util.addIfNotNone(properties, "clientReconnectTimeout", roleProperties.optString("websphere.mqqueueconnectionfactory.clientreconnecttimeout", "1800"));
  print "Creating MQQueueConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MQQueueConnectionFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQQueueConnectionFactory');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MQQueueConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("MQQueueConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mqqueueconnectionfactory.name"):
    raise Exception("Resource role properties does not contain websphere.mqqueueconnectionfactory.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.wmqserversvrconnchannel", None), "wmqServerSvrconnChannel","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.diagnoseconnectionusage", None), "diagnoseConnectionUsage","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.ccsid", None), "CCSID","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.rcvexit", None), "rcvExit","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.wmqservername", None), "wmqServerName","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sslconfiguration", None), "sslConfiguration","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.host", None), "host","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.category", None), "category","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.tempmodel", None), "tempModel","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.replywithrfh2", None), "replyWithRFH2","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.inheritrrscontext", "false"), "inheritRRSContext","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.secexit", None), "secExit","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.name", None), "name","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.xarecoveryauthalias", None), "xaRecoveryAuthAlias","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.description", None), "description","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.useconnectionpooling", None), "useConnectionPooling","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.managecachedhandles", None), "manageCachedHandles","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.wmqserverendpoint", None), "wmqServerEndpoint","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.ccdturl", None), "ccdtUrl","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.providerversion", None), "providerVersion","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sslresetcount", None), "sslResetCount","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.secexitinitdata", None), "secExitInitData","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.pollinginterval", None), "pollingInterval","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.msgretention", None), "msgRetention","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.queuemanager", None), "queueManager","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.jndiname", None), "jndiName","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sendexit", None), "sendExit","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.clientreconnectoptions", "DISABLED"), "clientReconnectOptions","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.authmechanismpreference", None), "authMechanismPreference","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sendexitinitdata", None), "sendExitInitData","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.maxbatchsize", None), "maxBatchSize","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.tempqueueprefix", None), "tempQueuePrefix","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.xaenabled", None), "XAEnabled","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.providertype", None), "providerType","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.rcvexitinitdata", None), "rcvExitInitData","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.channel", None), "channel","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.port", None), "port","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.authdataalias", None), "authDataAlias","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sslpeername", None), "sslPeerName","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.rescaninterval", None), "rescanInterval","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.compressheaders", None), "compressHeaders","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.failifquiesce", None), "failIfQuiesce","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.clientid", None), "clientID","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.localaddress", None), "localAddress","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sslcrl", None), "sslCRL","MQQueueConnectionFactory");
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.mqqueueconnectionfactory.connamelist"):
    Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.connamelist", ""), "connameList","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.logmissingtransactioncontext", None), "logMissingTransactionContext","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.transporttype", None), "transportType","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.sslciphersuite", None), "sslCipherSuite","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.compresspayload", None), "compressPayload","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.qmgrtype", None), "qmgrType","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.ssltype", None), "sslType","MQQueueConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mqqueueconnectionfactory.clientreconnecttimeout", "1800"), "clientReconnectTimeout","MQQueueConnectionFactory");
  if len(atts) != 0:
    print "Modifying MQQueueConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MQQueueConnectionFactory configuration up to date.";

  connPool = Util.getOptionalAttribute(objid, 'connectionPool', 'MQQueueConnectionFactory');
  if connPool is not None and len(connPool) > 0:
    Util.remove(connPool);

  mapping = Util.getOptionalAttribute(objid, 'mapping', 'MQQueueConnectionFactory');
  if mapping is not None and len(mapping) > 0:
    Util.remove(mapping);

  sessPool = Util.getOptionalAttribute(objid, 'sessionPool', 'MQQueueConnectionFactory');
  if sessPool is not None and len(sessPool) > 0:
    Util.remove(sessPool);

  Property.removeProperties(objid, 'properties',"MQQueueConnectionFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereConnectionPool":
        poolname = curjsonobject.getString("name");
        if poolname == "ConnectionPool":
          ConnectionPool.create(objid, curjsonobject, "connectionPool");
        elif poolname == "SessionPool":
          ConnectionPool.create(objid, curjsonobject, "sessionPool");
        else:
          ConnectionPool.create(objid, curjsonobject);
      elif currole == "WebSphereMappingModule":
        MappingModule.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MQQueueConnectionFactory');
