from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MatchCriteria')

  if len(name) == 0:
    name = Util.getRequiredAttribute(objid, 'name', 'MatchCriteria');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMatchCriteria");
  exportedObject.put("roleName", "WebSphereMatchCriteria");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchcriteria.name", objid, "name","MatchCriteria");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchcriteria.description", objid, "description","MatchCriteria");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchcriteria.value", objid, "value","MatchCriteria");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MatchCriteria');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MatchCriteria')
  if not jsonobject.has("roleProperties"):
    raise Exception("MatchCriteria resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.matchcriteria.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.matchcriteria.description", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.matchcriteria.value", None));
  print "Creating MatchCriteria with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MatchCriteria", parentid, properties);
  Util.popPathElement('MatchCriteria');

def update(objid,jsonobject):
  Util.pushPathElement('MatchCriteria')
  if not jsonobject.has("roleProperties"):
    raise Exception("MatchCriteria resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchcriteria.name", None), "name","MatchCriteria");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchcriteria.description", None), "description","MatchCriteria");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchcriteria.value", None), "value","MatchCriteria");
  if len(atts) != 0:
    print "Modifying MatchCriteria with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MatchCriteria configuration up to date.";

  Util.popPathElement('MatchCriteria');
