from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MemoryLeakAlgorithm')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMemoryLeakAlgorithm");
  exportedObject.put("roleName", "WebSphereMemoryLeakAlgorithm");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memoryleakalgorithm.name", objid, "name","MemoryLeakAlgorithm");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memoryleakalgorithm.conditionexpr", objid, "conditionExpr","MemoryLeakAlgorithm");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.memoryleakalgorithm.level", objid, "level","MemoryLeakAlgorithm");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MemoryLeakAlgorithm');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MemoryLeakAlgorithm')
  if not jsonobject.has("roleProperties"):
    raise Exception("MemoryLeakAlgorithm resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.memoryleakalgorithm.name", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.memoryleakalgorithm.conditionexpr", None));
  Util.addIfNotNone(properties, "level", roleProperties.optString("websphere.memoryleakalgorithm.level", None));
  print "Creating MemoryLeakAlgorithm with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MemoryLeakAlgorithm", parentid, properties);
  Util.popPathElement('MemoryLeakAlgorithm');

def update(objid,jsonobject):
  Util.pushPathElement('MemoryLeakAlgorithm')
  if not jsonobject.has("roleProperties"):
    raise Exception("MemoryLeakAlgorithm resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memoryleakalgorithm.name", None), "name","MemoryLeakAlgorithm");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memoryleakalgorithm.conditionexpr", None), "conditionExpr","MemoryLeakAlgorithm");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.memoryleakalgorithm.level", None), "level","MemoryLeakAlgorithm");
  if len(atts) != 0:
    print "Modifying MemoryLeakAlgorithm with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MemoryLeakAlgorithm configuration up to date.";

  Util.popPathElement('MemoryLeakAlgorithm');

def getMemoryLeakAlgorithm(objid):
  memoryLeakAlgorithm = Util.getAssociatedObjects(objid, "MemoryLeakAlgorithm");
  return memoryLeakAlgorithm;
