from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MiddlewareWebModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareWebModule");
  exportedObject.put("roleName", "WebSphereMiddlewareWebModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewarewebmodule.virtualhostname", objid, "virtualHostName","MiddlewareWebModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewarewebmodule.name", objid, "name","MiddlewareWebModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewarewebmodule.contextroot", objid, "contextRoot","MiddlewareWebModule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MiddleWebModule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareWebModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareWebModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareWebModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "virtualHostName", roleProperties.optString("websphere.middlewarewebmodule.virtualhostname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.middlewarewebmodule.name", None));
  Util.addIfNotNone(properties, "contextRoot", roleProperties.optString("websphere.middlewarewebmodule.contextroot", None));
  print "Creating MiddlewareWebModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareWebModule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareWebModule');

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareWebModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareWebModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewarewebmodule.virtualhostname", None), "virtualHostName","MiddlewareWebModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewarewebmodule.name", None), "name","MiddlewareWebModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewarewebmodule.contextroot", None), "contextRoot","MiddlewareWebModule");
  if len(atts) != 0:
    print "Modifying MiddlewareWebModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareWebModule configuration up to date.";

  Property.removeProperties(objid, 'properties',"MiddlewareWebModule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareWebModule');
