#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ResourceRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereResourceRef");
  exportedObject.put("roleName", "WebSphereResourceRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.lookupname", objid, "lookupName","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.name", objid, "name","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.auth", objid, "auth","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.type", objid, "type","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.link", objid, "link","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.description", objid, "description","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.ressharingscope", objid, "resSharingScope","ResourceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.resourceref.mappedname", objid, "mappedName","ResourceRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ResourceRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'ResourceRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ResourceRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ResourceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.resourceref.lookupname", ""));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.resourceref.name", None));
  Util.addIfNotNone(properties, "auth", roleProperties.optString("websphere.resourceref.auth", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.resourceref.type", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.resourceref.link", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.resourceref.description", None));
  Util.addIfNotNone(properties, "resSharingScope", roleProperties.optString("websphere.resourceref.ressharingscope", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.resourceref.mappedname", None));
  print "Creating ResourceRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ResourceRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('ResourceRef');

def update(objid,jsonobject):
  Util.pushPathElement('ResourceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResourceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.lookupname", ""), "lookupName","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.name", None), "name","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.auth", None), "auth","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.type", None), "type","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.link", None), "link","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.description", None), "description","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.ressharingscope", None), "resSharingScope","ResourceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.resourceref.mappedname", None), "mappedName","ResourceRef");
  if len(atts) != 0:
    print "Modifying ResourceRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ResourceRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ResourceRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'ResourceRef');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('ResourceRef');
