from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQLocalizationPointProxy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQLocalizationPointProxy");
  exportedObject.put("roleName", "WebSphereSIBMQLocalizationPointProxy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.inboundpersistentreliability", objid, "inboundPersistentReliability","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.enablerfh2header", objid, "enableRFH2Header","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.identifier", objid, "identifier","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.uuid", objid, "uuid","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.inboundnonpersistentreliability", objid, "inboundNonPersistentReliability","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.targetuuid", objid, "targetUuid","SIBMQLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlocalizationpointproxy.mqqueuename", objid, "mqQueueName","SIBMQLocalizationPointProxy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQLocalizationPointProxy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQLocalizationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLocalizationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundPersistentReliability", roleProperties.optString("websphere.sibmqlocalizationpointproxy.inboundpersistentreliability", None));
  Util.addIfNotNone(properties, "enableRFH2Header", roleProperties.optString("websphere.sibmqlocalizationpointproxy.enablerfh2header", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmqlocalizationpointproxy.identifier", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqlocalizationpointproxy.uuid", None));
  Util.addIfNotNone(properties, "inboundNonPersistentReliability", roleProperties.optString("websphere.sibmqlocalizationpointproxy.inboundnonpersistentreliability", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmqlocalizationpointproxy.targetuuid", None));
  Util.addIfNotNone(properties, "mqQueueName", roleProperties.optString("websphere.sibmqlocalizationpointproxy.mqqueuename", None));
  print "Creating SIBMQLocalizationPointProxy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQLocalizationPointProxy", parentid, properties);
  Util.popPathElement('SIBMQLocalizationPointProxy');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQLocalizationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLocalizationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.inboundpersistentreliability", None), "inboundPersistentReliability","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.enablerfh2header", None), "enableRFH2Header","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.identifier", None), "identifier","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.uuid", None), "uuid","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.inboundnonpersistentreliability", None), "inboundNonPersistentReliability","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.targetuuid", None), "targetUuid","SIBMQLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlocalizationpointproxy.mqqueuename", None), "mqQueueName","SIBMQLocalizationPointProxy");
  if len(atts) != 0:
    print "Modifying SIBMQLocalizationPointProxy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQLocalizationPointProxy configuration up to date.";

  Util.popPathElement('SIBMQLocalizationPointProxy');
