from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBQueueLocalizationPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBQueueLocalizationPoint");
  exportedObject.put("roleName", "WebSphereSIBQueueLocalizationPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqueuelocalizationpoint.identifier", objid, "identifier","SIBQueueLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqueuelocalizationpoint.highmessagethreshold", objid, "highMessageThreshold","SIBQueueLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqueuelocalizationpoint.uuid", objid, "uuid","SIBQueueLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqueuelocalizationpoint.targetuuid", objid, "targetUuid","SIBQueueLocalizationPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibqueuelocalizationpoint.sendallowed", objid, "sendAllowed","SIBQueueLocalizationPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBQueueLocalizationPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBQueueLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBQueueLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibqueuelocalizationpoint.identifier", None));
  Util.addIfNotNone(properties, "highMessageThreshold", roleProperties.optString("websphere.sibqueuelocalizationpoint.highmessagethreshold", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibqueuelocalizationpoint.uuid", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibqueuelocalizationpoint.targetuuid", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibqueuelocalizationpoint.sendallowed", None));
  print "Creating SIBQueueLocalizationPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBQueueLocalizationPoint", parentid, properties);
  Util.popPathElement('SIBQueueLocalizationPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SIBQueueLocalizationPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBQueueLocalizationPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqueuelocalizationpoint.identifier", None), "identifier","SIBQueueLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqueuelocalizationpoint.highmessagethreshold", None), "highMessageThreshold","SIBQueueLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqueuelocalizationpoint.uuid", None), "uuid","SIBQueueLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqueuelocalizationpoint.targetuuid", None), "targetUuid","SIBQueueLocalizationPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibqueuelocalizationpoint.sendallowed", None), "sendAllowed","SIBQueueLocalizationPoint");
  if len(atts) != 0:
    print "Modifying SIBQueueLocalizationPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBQueueLocalizationPoint configuration up to date.";

  Util.popPathElement('SIBQueueLocalizationPoint');
