from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SessionDatabasePersistence')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSessionDatabasePersistence");
  exportedObject.put("roleName", "WebSphereSessionDatabasePersistence");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessiondatabasepersistence.password", objid, "password","SessionDatabasePersistence");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessiondatabasepersistence.userid", objid, "userId","SessionDatabasePersistence");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessiondatabasepersistence.tablespacename", objid, "tableSpaceName","SessionDatabasePersistence");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessiondatabasepersistence.datasourcejndiname", objid, "datasourceJNDIName","SessionDatabasePersistence");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sessiondatabasepersistence.db2rowsize", objid, "db2RowSize","SessionDatabasePersistence");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SessionDatabasePersistence');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SessionDatabasePersistence')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionDatabasePersistence resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.sessiondatabasepersistence.password", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.sessiondatabasepersistence.userid", None));
  Util.addIfNotNone(properties, "tableSpaceName", roleProperties.optString("websphere.sessiondatabasepersistence.tablespacename", None));
  Util.addIfNotNone(properties, "datasourceJNDIName", roleProperties.optString("websphere.sessiondatabasepersistence.datasourcejndiname", None));
  Util.addIfNotNone(properties, "db2RowSize", roleProperties.optString("websphere.sessiondatabasepersistence.db2rowsize", None));
  print "Creating SessionDatabasePersistence with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SessionDatabasePersistence", parentid, properties);
  Util.popPathElement('SessionDatabasePersistence');

def update(objid,jsonobject):
  Util.pushPathElement('SessionDatabasePersistence')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionDatabasePersistence resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessiondatabasepersistence.password", None), "password","SessionDatabasePersistence");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessiondatabasepersistence.userid", None), "userId","SessionDatabasePersistence");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessiondatabasepersistence.tablespacename", None), "tableSpaceName","SessionDatabasePersistence");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessiondatabasepersistence.datasourcejndiname", None), "datasourceJNDIName","SessionDatabasePersistence");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sessiondatabasepersistence.db2rowsize", None), "db2RowSize","SessionDatabasePersistence");
  if len(atts) != 0:
    print "Modifying SessionDatabasePersistence with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SessionDatabasePersistence configuration up to date.";

  Util.popPathElement('SessionDatabasePersistence');
