from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TraceLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTraceLog");
  exportedObject.put("roleName", "WebSphereTraceLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tracelog.maxnumberofbackupfiles", objid, "maxNumberOfBackupFiles","TraceLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tracelog.rolloversize", objid, "rolloverSize","TraceLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tracelog.filename", objid, "fileName","TraceLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TraceLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TraceLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("TraceLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxNumberOfBackupFiles", roleProperties.optString("websphere.tracelog.maxnumberofbackupfiles", None));
  Util.addIfNotNone(properties, "rolloverSize", roleProperties.optString("websphere.tracelog.rolloversize", None));
  Util.addIfNotNone(properties, "fileName", roleProperties.optString("websphere.tracelog.filename", None));
  print "Creating TraceLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TraceLog", parentid, properties);
  Util.popPathElement('TraceLog');

def update(objid,jsonobject):
  Util.pushPathElement('TraceLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("TraceLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tracelog.maxnumberofbackupfiles", None), "maxNumberOfBackupFiles","TraceLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tracelog.rolloversize", None), "rolloverSize","TraceLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tracelog.filename", None), "fileName","TraceLog");
  if len(atts) != 0:
    print "Modifying TraceLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TraceLog configuration up to date.";

  Util.popPathElement('TraceLog');
