from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASAddressingType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASAddressingType");
  exportedObject.put("roleName", "WebSphereWASAddressingType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasaddressingtype.enabled", objid, "enabled","WASAddressingType");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasaddressingtype.responses", objid, "responses","WASAddressingType");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasaddressingtype.required", objid, "required","WASAddressingType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASAddressingType');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASAddressingType')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASAddressingType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.wasaddressingtype.enabled", None));
  Util.addIfNotNone(properties, "responses", roleProperties.optString("websphere.wasaddressingtype.responses", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.wasaddressingtype.required", None));
  print "Creating WASAddressingType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASAddressingType", parentid, properties);
  Util.popPathElement('WASAddressingType');

def update(objid,jsonobject):
  Util.pushPathElement('WASAddressingType')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASAddressingType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasaddressingtype.enabled", None), "enabled","WASAddressingType");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasaddressingtype.responses", None), "responses","WASAddressingType");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasaddressingtype.required", None), "required","WASAddressingType");
  if len(atts) != 0:
    print "Modifying WASAddressingType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASAddressingType configuration up to date.";

  Util.popPathElement('WASAddressingType');
