#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from DisplayName import DisplayName
from IconType import IconType
from License import License
from ResourceAdapter import ResourceAdapter

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Connector')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereConnector");
  exportedObject.put("roleName", "WebSphereConnector");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.largeicon", objid, "largeIcon","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.eistype", objid, "eisType","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.vendorname", objid, "vendorName","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.version", objid, "version","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.smallicon", objid, "smallIcon","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.metadatacomplete", objid, "metadataComplete","Connector");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.connector.requiredworkcontext", objid, "requiredWorkContext","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.displayname", objid, "displayName","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.description", objid, "description","Connector");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.connector.specversion", objid, "specVersion","Connector");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'Connector');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'Connector');
  for displayName in displayNames:
    if len(displayName) > 0:
      returndict = Util.createTypeFolder(respath, "DisplayName", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DisplayName._export(displayName, currespath, "DisplayName%s" % i));
      i = i + 1;

  i = 0;
  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'Connector');
  for icon in icons:
    if len(icon) > 0:
      returndict = Util.createTypeFolder(respath, "IconType", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, IconType._export(icon, currespath, "Icon%s" % i));
      i = i + 1;

  lic = Util.getOptionalAttribute(objid, 'license', 'Connector');
  if lic is not None and len(lic) > 0:
    returndict = Util.createTypeFolder(respath, 'License', typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, License._export(lic, currespath, "License"));

  adapter = Util.getOptionalAttribute(objid, 'resourceAdapter', 'Connector');
  if adapter is not None and len(adapter) > 0:
    returndict = Util.createTypeFolder(respath, 'ResourceAdapter', typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ResourceAdapter._export(adapter, currespath, "ResourceAdapter"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Connector');
  return result;


def create(parentid, jsonobject):
  Util.pushPathElement('Connector')
  if not jsonobject.has("roleProperties"):
    raise Exception("Connector resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "largeIcon", roleProperties.optString("websphere.connector.largeicon", None));
  Util.addIfNotNone(properties, "eisType", roleProperties.optString("websphere.connector.eistype", None));
  Util.addIfNotNone(properties, "vendorName", roleProperties.optString("websphere.connector.vendorname", None));
  Util.addIfNotNone(properties, "version", roleProperties.optString("websphere.connector.version", None));
  Util.addIfNotNone(properties, "smallIcon", roleProperties.optString("websphere.connector.smallicon", None));
  Util.addIfNotNone(properties, "metadataComplete", roleProperties.optString("websphere.connector.metadatacomplete", "false"));
  Util.addPathProperty(properties, "requiredWorkContext", roleProperties.optString("websphere.connector.requiredworkcontext", ""));
  Util.addIfNotNone(properties, "displayName", roleProperties.optString("websphere.connector.displayname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.connector.description", None));
  Util.addIfNotNone(properties, "specVersion", roleProperties.optString("websphere.connector.specversion", None));
  print "Creating Connector with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Connector", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
      elif currole == "WebSphereLicense":
        License.create(objid, curjsonobject);
      elif currole == "WebSphereResourceAdapter":
        ResourceAdapter.create(objid, curjsonobject);
  Util.popPathElement('Connector');


def update(objid,jsonobject):
  Util.pushPathElement('Connector')
  if not jsonobject.has("roleProperties"):
    raise Exception("Connector resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.largeicon", None), "largeIcon","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.eistype", None), "eisType","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.vendorname", None), "vendorName","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.version", None), "version","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.smallicon", None), "smallIcon","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.metadatacomplete", "false"), "metadataComplete","Connector");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.requiredworkcontext", ""), "requiredWorkContext","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.displayname", None), "displayName","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.description", None), "description","Connector");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.connector.specversion", None), "specVersion","Connector");
  if len(atts) != 0:
    print "Modifying Connector with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Connector configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'Connector');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'Connector');
  for displayName in displayNames:
    if len(displayName) > 0:
      Util.remove(displayName);

  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'Connector');
  for icon in icons:
    if len(icon) > 0:
      Util.remove(icon);

  lic = Util.getOptionalAttribute(objid, 'license', 'Connector');
  if lic is not None and len(lic) > 0:
    Util.remove(lic);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
      elif currole == "WebSphereLicense":
        License.create(objid, curjsonobject);
      elif currole == "WebSphereResourceAdapter":
        rAdapter = Util.getAssociatedObjects(objid, 'ResourceAdapter');
        if rAdapter is None or len(rAdapter) < 1:
          ResourceAdapter.create(objid, curjsonobject);
        else:
          ResourceAdapter.update(rAdapter[0], curjsonobject);
  Util.popPathElement('Connector');
