from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProtocolProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProtocolProvider");
  exportedObject.put("roleName", "WebSphereProtocolProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.protocolprovider.classpath", objid, "classpath","ProtocolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.protocolprovider.type", objid, "type","ProtocolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.protocolprovider.classname", objid, "classname","ProtocolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.protocolprovider.protocol", objid, "protocol","ProtocolProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProtocolProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProtocolProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProtocolProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.protocolprovider.classpath", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.protocolprovider.type", None));
  Util.addIfNotNone(properties, "classname", roleProperties.optString("websphere.protocolprovider.classname", None));
  Util.addIfNotNone(properties, "protocol", roleProperties.optString("websphere.protocolprovider.protocol", None));
  print "Creating ProtocolProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProtocolProvider", parentid, properties);
  Util.popPathElement('ProtocolProvider');

def update(objid,jsonobject):
  Util.pushPathElement('ProtocolProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProtocolProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.protocolprovider.classpath", None), "classpath","ProtocolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.protocolprovider.type", None), "type","ProtocolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.protocolprovider.classname", None), "classname","ProtocolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.protocolprovider.protocol", None), "protocol","ProtocolProvider");
  if len(atts) != 0:
    print "Modifying ProtocolProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProtocolProvider configuration up to date.";

  Util.popPathElement('ProtocolProvider');
