from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RemoteCellOverrides')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRemoteCellOverrides");
  exportedObject.put("roleName", "WebSphereRemoteCellOverrides");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.outboundsslalias", objid, "outboundSSLAlias","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.cacheinstancename", objid, "cacheInstanceName","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.sslcacheenable", objid, "sslCacheEnable","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.connectionpoolenable", objid, "connectionPoolEnable","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.maxconnectionsperserver", objid, "maxConnectionsPerServer","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.cacheupdateuri", objid, "cacheUpdateUri","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.enablecaching", objid, "enableCaching","RemoteCellOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecelloverrides.peeraccesspointname", objid, "peerAccessPointName","RemoteCellOverrides");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"RemoteCellOverrides");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RemoteCellOverrides');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RemoteCellOverrides')
  if not jsonobject.has("roleProperties"):
    raise Exception("RemoteCellOverrides resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outboundSSLAlias", roleProperties.optString("websphere.remotecelloverrides.outboundsslalias", None));
  Util.addIfNotNone(properties, "cacheInstanceName", roleProperties.optString("websphere.remotecelloverrides.cacheinstancename", None));
  Util.addIfNotNone(properties, "sslCacheEnable", roleProperties.optString("websphere.remotecelloverrides.sslcacheenable", None));
  Util.addIfNotNone(properties, "connectionPoolEnable", roleProperties.optString("websphere.remotecelloverrides.connectionpoolenable", None));
  Util.addIfNotNone(properties, "maxConnectionsPerServer", roleProperties.optString("websphere.remotecelloverrides.maxconnectionsperserver", None));
  Util.addIfNotNone(properties, "cacheUpdateUri", roleProperties.optString("websphere.remotecelloverrides.cacheupdateuri", None));
  Util.addIfNotNone(properties, "enableCaching", roleProperties.optString("websphere.remotecelloverrides.enablecaching", None));
  Util.addIfNotNone(properties, "peerAccessPointName", roleProperties.optString("websphere.remotecelloverrides.peeraccesspointname", None));
  print "Creating RemoteCellOverrides with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RemoteCellOverrides", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RemoteCellOverrides');

def update(objid,jsonobject):
  Util.pushPathElement('RemoteCellOverrides')
  if not jsonobject.has("roleProperties"):
    raise Exception("RemoteCellOverrides resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.outboundsslalias", None), "outboundSSLAlias","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.cacheinstancename", None), "cacheInstanceName","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.sslcacheenable", None), "sslCacheEnable","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.connectionpoolenable", None), "connectionPoolEnable","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.maxconnectionsperserver", None), "maxConnectionsPerServer","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.cacheupdateuri", None), "cacheUpdateUri","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.enablecaching", None), "enableCaching","RemoteCellOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecelloverrides.peeraccesspointname", None), "peerAccessPointName","RemoteCellOverrides");
  if len(atts) != 0:
    print "Modifying RemoteCellOverrides with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RemoteCellOverrides configuration up to date.";

  Property.removeProperties(objid, 'properties',"RemoteCellOverrides");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RemoteCellOverrides');
