from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from WSScheduleRef import WSScheduleRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSSecurityScannerMonitor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSSecurityScannerMonitor");
  exportedObject.put("roleName", "WebSphereWSSecurityScannerMonitor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wssecurityscannermonitor.name", objid, "name","WSSecurityScannerMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wssecurityscannermonitor.isenabled", objid, "isEnabled","WSSecurityScannerMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wssecurityscannermonitor.extregfilterlistforstart", objid, "extRegFilterListForStart","WSSecurityScannerMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wssecurityscannermonitor.extregfilterlistforschedule", objid, "extRegFilterListForSchedule","WSSecurityScannerMonitor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  wsSchedule = Util.getOptionalAttribute(objid, 'wsSchedule', 'WSSecurityScannerMonitor');
  if wsSchedule is not None and len(wsSchedule) > 0:
    returndict = Util.createTypeFolder(respath, "WSScheduleRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WSScheduleRef._export(wsSchedule, currespath, "WSSchedule"));

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WSSecurityScannerMonitor");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSSecurityScannerMonitor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSSecurityScannerMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSSecurityScannerMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wssecurityscannermonitor.name", None));
  Util.addIfNotNone(properties, "isEnabled", roleProperties.optString("websphere.wssecurityscannermonitor.isenabled", None));
  Util.addIfNotNone(properties, "extRegFilterListForStart", roleProperties.optString("websphere.wssecurityscannermonitor.extregfilterlistforstart", None));
  Util.addIfNotNone(properties, "extRegFilterListForSchedule", roleProperties.optString("websphere.wssecurityscannermonitor.extregfilterlistforschedule", None));
  print "Creating WSSecurityScannerMonitor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSSecurityScannerMonitor", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if currole == "WebSphereWSScheduleRef":
        WSScheduleRef.create(objid, curjsonobject, "wsSchedule");
  Util.popPathElement('WSSecurityScannerMonitor');

def update(objid,jsonobject):
  Util.pushPathElement('WSSecurityScannerMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSSecurityScannerMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wssecurityscannermonitor.name", None), "name","WSSecurityScannerMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wssecurityscannermonitor.isenabled", None), "isEnabled","WSSecurityScannerMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wssecurityscannermonitor.extregfilterlistforstart", None), "extRegFilterListForStart","WSSecurityScannerMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wssecurityscannermonitor.extregfilterlistforschedule", None), "extRegFilterListForSchedule","WSSecurityScannerMonitor");
  if len(atts) != 0:
    print "Modifying WSSecurityScannerMonitor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "WSSecurityScannerMonitor configuration up to date.";

  Property.removeProperties(objid, 'properties',"WSSecurityScannerMonitor");
  Util.unsetAttribute(objid, "wsSchedule", "WSSecurityScannerMonitor");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereWSScheduleRef":
          WSScheduleRef.create(objid, curjsonobject, "wsSchedule");

  Util.popPathElement('WSSecurityScannerMonitor');
