from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Extension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExtension");
  exportedObject.put("roleName", "WebSphereExtension");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extension.name", objid, "name","Extension");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extension.configuri", objid, "configURI","Extension");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Extension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Extension')
  if not jsonobject.has("roleProperties"):
    raise Exception("Extension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extension.name", None));
  Util.addIfNotNone(properties, "configURI", roleProperties.optString("websphere.extension.configuri", None));
  print "Creating Extension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Extension", parentid, properties);
  Util.popPathElement('Extension');

def update(objid,jsonobject):
  Util.pushPathElement('Extension')
  if not jsonobject.has("roleProperties"):
    raise Exception("Extension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extension.name", None), "name","Extension");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extension.configuri", None), "configURI","Extension");
  if len(atts) != 0:
    print "Modifying Extension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Extension configuration up to date.";

  Util.popPathElement('Extension');
