from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProxyInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'ProxyInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxyInboundChannel");
  exportedObject.put("roleName", "WebSphereProxyInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyinboundchannel.name", objid, "name","ProxyInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyinboundchannel.discriminationweight", objid, "discriminationWeight","ProxyInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ProxyInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProxyInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProxyInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.proxyinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.proxyinboundchannel.discriminationweight", None));
  print "Creating ProxyInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProxyInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ProxyInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyinboundchannel.name", None), "name","ProxyInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyinboundchannel.discriminationweight", None), "discriminationWeight","ProxyInboundChannel");
  if len(atts) != 0:
    print "Modifying ProxyInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProxyInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"ProxyInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyInboundChannel');
