#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2016. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
import re;
from WASConfLog import Log;
from utilities import Util
from SIBAuthUser import SIBAuthUser

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('SIBAuthUserRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthUserRef");
  exportedObject.put("roleName", "WebSphereSIBAuthUserRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.SIBAuthUser.identifier", objid, "identifier","SIBAuthUser");

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthUserRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('SIBAuthUserRef')

  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthUserRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.SIBAuthUser.identifier'):
    raise Exception("SIBAuthUserRef resource has no property named websphere.SIBAuthUser.identifier!");

  targetIdentifier = roleProperties.getString('websphere.SIBAuthUser.identifier')

  SIBAuthUserId = None;
  SIBAuthUsers = Util.getid("/SIBAuthUser:/").splitlines();
  if len(SIBAuthUsers) > 0:
    for SIBAuthUser in SIBAuthUsers:
      curIdentifier = Util.getOptionalAttribute(SIBAuthUser, "identifier", "SIBAuthUser" );
      if curIdentifier == targetIdentifier:
        SIBAuthUserId = SIBAuthUser;
        break;

  if SIBAuthUserId is None or len(SIBAuthUserId) < 1:
    raise Exception("Could not find SIBAuthUser with identifier %(name)s" % { 'name':targetIdentifier } );

  properties = [];
  properties.append([parentAtt, SIBAuthUserId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating SIBAuthUserRef to %(id)s for attribute %(att)s" % { 'id':SIBAuthUserId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating SIBAuthUserRef to %(id)s for attribute %(att)s" % { 'id':SIBAuthUserId, 'att':parentAtt });
  Util.popPathElement('SIBAuthUserRef');
