from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSProvider");
  exportedObject.put("roleName", "WebSphereSIBJMSProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.sibjmsprovider.classpath", objid, "classpath","SIBJMSProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsprovider.name", objid, "name","SIBJMSProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsprovider.isolatedclassloader", objid, "isolatedClassLoader","SIBJMSProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.sibjmsprovider.nativepath", objid, "nativepath","SIBJMSProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsprovider.description", objid, "description","SIBJMSProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsprovider.providertype", objid, "providerType","SIBJMSProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.sibjmsprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmsprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.sibjmsprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.sibjmsprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmsprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmsprovider.providertype", None));
  print "Creating SIBJMSProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSProvider", parentid, properties);
  Util.popPathElement('SIBJMSProvider');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.classpath", None), "classpath","SIBJMSProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.name", None), "name","SIBJMSProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.isolatedclassloader", None), "isolatedClassLoader","SIBJMSProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.nativepath", None), "nativepath","SIBJMSProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.description", None), "description","SIBJMSProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsprovider.providertype", None), "providerType","SIBJMSProvider");
  if len(atts) != 0:
    print "Modifying SIBJMSProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSProvider configuration up to date.";

  Util.popPathElement('SIBJMSProvider');
