from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from TunnelAccessPointGroupRef import TunnelAccessPointGroupRef;
from utilities import Util
from Property import Property

__name_att__ = 'websphere.tunneltemplate.name';

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'TunnelTemplate');

  containmentpath = "%(parentconpath)sTunnelTemplate:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TunnelTemplate')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTunnelTemplate");
  exportedObject.put("roleName", "WebSphereTunnelTemplate");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tunneltemplate.name", objid, "name","TunnelTemplate");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tunneltemplate.usessl", objid, "useSSL","TunnelTemplate");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"TunnelTemplate");
  tunaccesspointgroupref = Util.getOptionalAttribute(objid, 'tunnelAccessPointGroupRef', 'TunnelTemplate');
  if tunaccesspointgroupref is not None and len(tunaccesspointgroupref) > 0:
    returndict = Util.createTypeFolder(respath, "TunnelAccessPointGroupRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, TunnelAccessPointGroupRef._export(tunaccesspointgroupref, currespath));
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TunnelTemplate');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelTemplate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.tunneltemplate.name"):
    raise Exception("Resource role properties does not contain websphere.tunneltemplate.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create TunnelTemplate on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('TunnelTemplate')
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelTemplate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.tunneltemplate.name", None));
  Util.addIfNotNone(properties, "useSSL", roleProperties.optString("websphere.tunneltemplate.usessl", None));
  print "Creating TunnelTemplate with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TunnelTemplate", parentid, properties);

  Util.unsetAttribute(objid, 'tunnelAccessPointGroupRef', 'TunnelTemplate');
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TunnelTemplate');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('TunnelTemplate')
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelTemplate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tunneltemplate.name", None), "name","TunnelTemplate");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tunneltemplate.usessl", None), "useSSL","TunnelTemplate");
  if len(atts) != 0:
    print "Modifying TunnelTemplate with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TunnelTemplate configuration up to date.";

  Property.removeProperties(objid, 'properties',"TunnelTemplate");
  Util.unsetAttribute(objid, 'tunnelAccessPointGroupRef', 'TunnelTemplate');

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TunnelTemplate');
