from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPDomain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPDomain");
  exportedObject.put("roleName", "WebSphereDPDomain");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomain.highestversion", objid, "highestVersion","DPDomain");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpdomain.name", objid, "name","DPDomain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPDomain");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPDomain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "highestVersion", roleProperties.optString("websphere.dpdomain.highestversion", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.dpdomain.name", None));
  print "Creating DPDomain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPDomain", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDomain');

def update(objid,jsonobject):
  Util.pushPathElement('DPDomain')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPDomain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomain.highestversion", None), "highestVersion","DPDomain");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpdomain.name", None), "name","DPDomain");
  if len(atts) != 0:
    print "Modifying DPDomain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPDomain configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPDomain");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPDomain');
