#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(parentrespath, attribute, propertyForOutput, propertyForInput):
  Util.pushPathElement('FederatedRepositoryAttributeMapping');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':attribute }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", attribute);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFederatedRepositoryAttributeMapping");
  exportedObject.put("roleName", "WebSphereFederatedRepositoryAttributeMapping");

  roleProperties = JSONObject();

  Util.addToJsonIfNotNone(roleProperties, "attribute", attribute);
  Util.addToJsonIfNotNone(roleProperties, "propertyForOutput", propertyForOutput);
  Util.addToJsonIfNotNone(roleProperties, "propertyForInput", propertyForInput);

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('FederatedRepositoryAttributeMapping');
  return result;

def update(jsonobject):
  Util.pushPathElement('FederatedRepositoryAttributeMapping');
  if not jsonobject.has("roleProperties"):
    raise Exception("FederatedRepositoryAttributeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  attribute = roleProperties.optString("attribute", None);
  propertyForOutput = roleProperties.optString("propertyForOutput", None);
  propertyForInput = roleProperties.optString("propertyForInput", None);
  setIdMgrRealmURAttrMappingParams = "[-URAttrName " + attribute + " -propertyForInput " + propertyForInput + " -propertyForOutput " + propertyForOutput + "]";
  Log.debug("Running command to add federated repository attribute mapping: AdminTask.setIdMgrRealmURAttrMapping(" + setIdMgrRealmURAttrMappingParams + ")");
  Util.setIdMgrRealmURAttrMapping(setIdMgrRealmURAttrMappingParams);
  Util.popPathElement('FederatedRepositoryAttributeMapping');

