from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from J2EEResourceProperty import J2EEResourceProperty
from AdminObjectRef import AdminObjectRef

__name_att__ = "websphere.j2cadminobject.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'J2CAdminObject');

  containmentpath = "%(parentconpath)sJ2CAdminObject:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('J2CAdminObject')

  name = Util.getRequiredAttribute(objid, "name", 'J2CAdminObject');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2CAdminObject");
  exportedObject.put("roleName", "WebSphereJ2CAdminObject");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cadminobject.name", objid, "name","J2CAdminObject");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cadminobject.description", objid, "description","J2CAdminObject");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2cadminobject.jndiname", objid, "jndiName","J2CAdminObject");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  resourceProperties = Util.parseConfigIdListAttribute(objid, 'properties', 'J2CAdminObject');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  adminObject = Util.getOptionalAttribute(objid, 'adminObject', 'J2CAdminObject');
  if adminObject is not None and len(adminObject) > 0:
    returndict = Util.createTypeFolder(respath, "AdminObjectRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    adminObjectName = Util.getRequiredAttribute(adminObject, "adminObjectClass", "AdminObject" );
    Util.addAllFromExport(extraObjects, AdminObjectRef._export(adminObject, currespath, adminObjectName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2CAdminObject');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CAdminObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.j2cadminobject.name"):
    raise Exception("Resource role properties does not contain websphere.j2cadminobject.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create J2CAdminObject on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('J2CAdminObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CAdminObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.j2cadminobject.name"):
    raise Exception("Resource role properties does not contain websphere.j2cadminobject.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.j2cadminobject.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.j2cadminobject.description", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.j2cadminobject.jndiname", None));

  # The referenced AdminObject needs to be added as a property during create
  # So, we are doing things a little out of order here.
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereAdminObjectRef":
        referencedAdminObject = AdminObjectRef.getReferencedAdminObject(parentid, curjsonobject);
        Util.addIfNotNone(properties, "adminObject", referencedAdminObject);
        break;

  print "Creating J2CAdminObject with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("J2CAdminObject", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
  Util.popPathElement('J2CAdminObject');

  return objid;


def update(objid,jsonobject):
  Util.pushPathElement('J2CAdminObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2CAdminObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.j2cadminobject.name"):
    raise Exception("Resource role properties does not contain websphere.j2cadminobject.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cadminobject.name", None), "name","J2CAdminObject");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cadminobject.description", None), "description","J2CAdminObject");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2cadminobject.jndiname", None), "jndiName","J2CAdminObject");
  if len(atts) != 0:
    print "Modifying J2CAdminObject with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2CAdminObject configuration up to date.";

  Util.unsetAttribute(objid, 'adminObject',"J2CAdminObject");

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'properties', 'J2CAdminObject');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
      elif currole == "WebSphereAdminObjectRef":
        AdminObjectRef.doImport(objid, curjsonobject);
  Util.popPathElement('J2CAdminObject');
