from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.preferenceset.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'PreferenceSet');

  containmentpath = "%(parentconpath)sPreferenceSet:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('PreferenceSet')

  name = Util.getRequiredAttribute(objid, "name", 'PreferenceSet');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePreferenceSet");
  exportedObject.put("roleName", "WebSpherePreferenceSet");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.preferenceset.name", objid, "name","PreferenceSet");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PreferenceSet');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("PreferenceSet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.preferenceset.name"):
    raise Exception("Resource role properties does not contain websphere.preferenceset.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create PreferenceSet on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('PreferenceSet')
  if not jsonobject.has("roleProperties"):
    raise Exception("PreferenceSet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.preferenceset.name"):
    raise Exception("Resource role properties does not contain websphere.preferenceset.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.preferenceset.name", None));
  print "Creating PreferenceSet with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PreferenceSet", parentid, properties);
  Util.popPathElement('PreferenceSet');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('PreferenceSet')
  if not jsonobject.has("roleProperties"):
    raise Exception("PreferenceSet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.preferenceset.name"):
    raise Exception("Resource role properties does not contain websphere.preferenceset.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.preferenceset.name", None), "name","PreferenceSet");
  if len(atts) != 0:
    print "Modifying PreferenceSet with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PreferenceSet configuration up to date.";

  Util.popPathElement('PreferenceSet');
