from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonbnd.CertStoreRef");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonbnd.CertStoreRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.certstoreref.ref", objid, "ref","com.ibm.etools.webservice.wscommonbnd.CertStoreRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.CertStoreRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ref", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.certstoreref.ref", None));
  print "Creating com.ibm.etools.webservice.wscommonbnd.CertStoreRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonbnd.CertStoreRef", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.CertStoreRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.certstoreref.ref", None), "ref","com.ibm.etools.webservice.wscommonbnd.CertStoreRef");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonbnd.CertStoreRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonbnd.CertStoreRef configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.CertStoreRef');
