from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GSCMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGSCMember");
  exportedObject.put("roleName", "WebSphereGSCMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gscmember.port", objid, "port","GSCMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gscmember.hostname", objid, "hostName","GSCMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GSCMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GSCMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("GSCMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.gscmember.port", None));
  Util.addIfNotNone(properties, "hostName", roleProperties.optString("websphere.gscmember.hostname", None));
  print "Creating GSCMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GSCMember", parentid, properties);
  Util.popPathElement('GSCMember');

def update(objid,jsonobject):
  Util.pushPathElement('GSCMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("GSCMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gscmember.port", None), "port","GSCMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gscmember.hostname", None), "hostName","GSCMember");
  if len(atts) != 0:
    print "Modifying GSCMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GSCMember configuration up to date.";

  Util.popPathElement('GSCMember');
