from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ModuleConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereModuleConfig");
  exportedObject.put("roleName", "WebSphereModuleConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduleconfig.name", objid, "name","ModuleConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.moduleconfig.description", objid, "description","ModuleConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ModuleConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ModuleConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.moduleconfig.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.moduleconfig.description", None));
  print "Creating ModuleConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ModuleConfig", parentid, properties);
  Util.popPathElement('ModuleConfig');

def update(objid,jsonobject):
  Util.pushPathElement('ModuleConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduleconfig.name", None), "name","ModuleConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.moduleconfig.description", None), "description","ModuleConfig");
  if len(atts) != 0:
    print "Modifying ModuleConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ModuleConfig configuration up to date.";

  Util.popPathElement('ModuleConfig');
