from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMIRequestMetrics')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMIRequestMetrics");
  exportedObject.put("roleName", "WebSpherePMIRequestMetrics");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.enablearm", objid, "enableARM","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.tracelevel", objid, "traceLevel","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.armtype", objid, "armType","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.dynamicenable", objid, "dynamicEnable","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.armtransactionfactory", objid, "armTransactionFactory","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.enablelog", objid, "enableLog","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.armcallback", objid, "armCallback","PMIRequestMetrics");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.pmirequestmetrics.instrumentedcomponents", objid, "instrumentedComponents","PMIRequestMetrics");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.pmirequestmetrics.enabledcomponents", objid, "enabledComponents","PMIRequestMetrics");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirequestmetrics.enable", objid, "enable","PMIRequestMetrics");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMIRequestMetrics');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMIRequestMetrics')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRequestMetrics resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableARM", roleProperties.optString("websphere.pmirequestmetrics.enablearm", None));
  Util.addIfNotNone(properties, "traceLevel", roleProperties.optString("websphere.pmirequestmetrics.tracelevel", None));
  Util.addIfNotNone(properties, "armType", roleProperties.optString("websphere.pmirequestmetrics.armtype", None));
  Util.addIfNotNone(properties, "dynamicEnable", roleProperties.optString("websphere.pmirequestmetrics.dynamicenable", None));
  Util.addIfNotNone(properties, "armTransactionFactory", roleProperties.optString("websphere.pmirequestmetrics.armtransactionfactory", None));
  Util.addIfNotNone(properties, "enableLog", roleProperties.optString("websphere.pmirequestmetrics.enablelog", None));
  Util.addIfNotNone(properties, "armCallback", roleProperties.optString("websphere.pmirequestmetrics.armcallback", None));
  Util.addPathProperty(properties, "instrumentedComponents", roleProperties.optString("websphere.pmirequestmetrics.instrumentedcomponents", None));
  Util.addPathProperty(properties, "enabledComponents", roleProperties.optString("websphere.pmirequestmetrics.enabledcomponents", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.pmirequestmetrics.enable", None));
  print "Creating PMIRequestMetrics with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMIRequestMetrics", parentid, properties);
  Util.popPathElement('PMIRequestMetrics');

def update(objid,jsonobject):
  Util.pushPathElement('PMIRequestMetrics')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRequestMetrics resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.enablearm", None), "enableARM","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.tracelevel", None), "traceLevel","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.armtype", None), "armType","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.dynamicenable", None), "dynamicEnable","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.armtransactionfactory", None), "armTransactionFactory","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.enablelog", None), "enableLog","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.armcallback", None), "armCallback","PMIRequestMetrics");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.instrumentedcomponents", None), "instrumentedComponents","PMIRequestMetrics");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.enabledcomponents", None), "enabledComponents","PMIRequestMetrics");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirequestmetrics.enable", None), "enable","PMIRequestMetrics");
  if len(atts) != 0:
    print "Modifying PMIRequestMetrics with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMIRequestMetrics configuration up to date.";

  Util.popPathElement('PMIRequestMetrics');
