from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PluginConfigPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePluginConfigPolicy");
  exportedObject.put("roleName", "WebSpherePluginConfigPolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginconfigpolicy.plugingenconfigscope", objid, "pluginGenConfigScope","PluginConfigPolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pluginconfigpolicy.pluginconfigchangescript", objid, "pluginConfigChangeScript","PluginConfigPolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"PluginConfigPolicy");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PluginConfigPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PluginConfigPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginConfigPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "pluginGenConfigScope", roleProperties.optString("websphere.pluginconfigpolicy.plugingenconfigscope", None));
  Util.addIfNotNone(properties, "pluginConfigChangeScript", roleProperties.optString("websphere.pluginconfigpolicy.pluginconfigchangescript", None));
  print "Creating PluginConfigPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PluginConfigPolicy", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PluginConfigPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('PluginConfigPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("PluginConfigPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginconfigpolicy.plugingenconfigscope", None), "pluginGenConfigScope","PluginConfigPolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pluginconfigpolicy.pluginconfigchangescript", None), "pluginConfigChangeScript","PluginConfigPolicy");
  if len(atts) != 0:
    print "Modifying PluginConfigPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PluginConfigPolicy configuration up to date.";

  Property.removeProperties(objid, 'properties',"PluginConfigPolicy");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('PluginConfigPolicy');
