from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBTopicSpaceMapEntry import SIBTopicSpaceMapEntry

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBTopicSpaceMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBTopicSpaceMapping");
  exportedObject.put("roleName", "WebSphereSIBTopicSpaceMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspacemapping.description", objid, "description","SIBTopicSpaceMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  topicSpaceMapEntries = Util.parseConfigIdListAttribute(objid, 'topicSpaceMapEntry',"SIBTopicSpaceMapping");
  for topicSpaceMapEntry in topicSpaceMapEntries:
    if len(topicSpaceMapEntry) > 0:
      returndict = Util.createTypeFolder(respath, "SIBTopicSpaceMapEntry", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBTopicSpaceMapEntry._export(topicSpaceMapEntry, currespath, "Topic Space Map Entry%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBTopicSpaceMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBTopicSpaceMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibtopicspacemapping.description", None));
  print "Creating SIBTopicSpaceMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBTopicSpaceMapping", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBTopicSpaceMapEntry":
        SIBTopicSpaceMapEntry.create(objid, curjsonobject);
  Util.popPathElement('SIBTopicSpaceMapping');

def update(objid,jsonobject):
  Util.pushPathElement('SIBTopicSpaceMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspacemapping.description", None), "description","SIBTopicSpaceMapping");
  if len(atts) != 0:
    print "Modifying SIBTopicSpaceMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBTopicSpaceMapping configuration up to date.";

  topicSpaceMapEntries = Util.parseConfigIdListAttribute(objid, 'topicSpaceMapEntry',"SIBTopicSpaceMapping");
  for topicSpaceMapEntry in topicSpaceMapEntries:
    if len(topicSpaceMapEntry) > 0:
      Util.remove(topicSpaceMapEntry);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBTopicSpaceMapEntry":
        SIBTopicSpaceMapEntry.create(objid, curjsonobject);

  Util.popPathElement('SIBTopicSpaceMapping');
