from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSOutboundService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSOutboundService");
  exportedObject.put("roleName", "WebSphereSIBWSOutboundService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundservice.name", objid, "name","SIBWSOutboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundservice.description", objid, "description","SIBWSOutboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundservice.enableoperationlevelsecurity", objid, "enableOperationLevelSecurity","SIBWSOutboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundservice.defaultport", objid, "defaultPort","SIBWSOutboundService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsoutboundservice.servicedestinationname", objid, "serviceDestinationName","SIBWSOutboundService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'property',"SIBWSOutboundService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSOutboundService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSOutboundService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSOutboundService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsoutboundservice.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsoutboundservice.description", None));
  Util.addIfNotNone(properties, "enableOperationLevelSecurity", roleProperties.optString("websphere.sibwsoutboundservice.enableoperationlevelsecurity", None));
  Util.addIfNotNone(properties, "defaultPort", roleProperties.optString("websphere.sibwsoutboundservice.defaultport", None));
  Util.addIfNotNone(properties, "serviceDestinationName", roleProperties.optString("websphere.sibwsoutboundservice.servicedestinationname", None));
  print "Creating SIBWSOutboundService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSOutboundService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSOutboundService');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSOutboundService')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSOutboundService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundservice.name", None), "name","SIBWSOutboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundservice.description", None), "description","SIBWSOutboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundservice.enableoperationlevelsecurity", None), "enableOperationLevelSecurity","SIBWSOutboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundservice.defaultport", None), "defaultPort","SIBWSOutboundService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsoutboundservice.servicedestinationname", None), "serviceDestinationName","SIBWSOutboundService");
  if len(atts) != 0:
    print "Modifying SIBWSOutboundService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSOutboundService configuration up to date.";

  Property.removeProperties(objid, 'property',"SIBWSOutboundService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIBWSOutboundService');
