from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.customprocessdefs.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'CustomProcessDefs');

  containmentpath = "%(parentconpath)sCustomProcessDefs:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('CustomProcessDefs')

  name = Util.getRequiredAttribute(objid, "name", 'CustomProcessDefs');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomProcessDefs");
  exportedObject.put("roleName", "WebSphereCustomProcessDefs");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customprocessdefs.name", objid, "name","CustomProcessDefs");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomProcessDefs');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.customprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.customprocessdefs.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create CustomProcessDefs on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomProcessDefs')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.customprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.customprocessdefs.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.customprocessdefs.name", None));
  print "Creating CustomProcessDefs with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomProcessDefs", parentid, properties);
  Util.popPathElement('CustomProcessDefs');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('CustomProcessDefs')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.customprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.customprocessdefs.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customprocessdefs.name", None), "name","CustomProcessDefs");
  if len(atts) != 0:
    print "Modifying CustomProcessDefs with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomProcessDefs configuration up to date.";

  Util.popPathElement('CustomProcessDefs');
