from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from AuditSpecificationRef import AuditSpecificationRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuditServiceProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuditServiceProvider");
  exportedObject.put("roleName", "WebSphereAuditServiceProvider");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.name", objid, "name","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.maxfilesize", objid, "maxFileSize","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.filelocation", objid, "fileLocation","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.classname", objid, "className","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.wrapbehavior", objid, "wrapBehavior","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.maxlogs", objid, "maxLogs","AuditServiceProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditserviceprovider.eventformatterclass", objid, "eventFormatterClass","AuditServiceProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  auditSpecifications = Util.parseConfigIdListAttribute(objid, 'auditSpecifications',"AuditServiceProvider");
  for auditSpecification in auditSpecifications:
    if auditSpecification is not None and len(auditSpecification) > 0:
      returndict = Util.createTypeFolder(respath, "AuditSpecificationRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AuditSpecificationRef._export(auditSpecification, currespath, Util.getRequiredAttribute(auditSpecification, 'name', 'AuditSpecification')));

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AuditServiceProvider");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuditServiceProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuditServiceProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditServiceProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.auditserviceprovider.name", None));
  Util.addIfNotNone(properties, "maxFileSize", roleProperties.optString("websphere.auditserviceprovider.maxfilesize", None));
  Util.addIfNotNone(properties, "fileLocation", roleProperties.optString("websphere.auditserviceprovider.filelocation", None));
  Util.addIfNotNone(properties, "className", roleProperties.optString("websphere.auditserviceprovider.classname", None));
  Util.addIfNotNone(properties, "wrapBehavior", roleProperties.optString("websphere.auditserviceprovider.wrapbehavior", "WRAP"));
  Util.addIfNotNone(properties, "maxLogs", roleProperties.optString("websphere.auditserviceprovider.maxlogs", None));
  Util.addIfNotNone(properties, "eventFormatterClass", roleProperties.optString("websphere.auditserviceprovider.eventformatterclass", None));
  print "Creating AuditServiceProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuditServiceProvider", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 1):
        continue;
      if currole == "WebSphereAuditSpecificationRef":
        AuditSpecificationRef.create(objid, curjsonobject, "auditSpecifications");
  Util.popPathElement('AuditServiceProvider');


def update(objid,jsonobject):
  Util.pushPathElement('AuditServiceProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditServiceProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.name", None), "name","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.maxfilesize", None), "maxFileSize","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.filelocation", None), "fileLocation","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.classname", None), "className","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.wrapbehavior", "WRAP"), "wrapBehavior","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.maxlogs", None), "maxLogs","AuditServiceProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditserviceprovider.eventformatterclass", None), "eventFormatterClass","AuditServiceProvider");
  if len(atts) != 0:
    print "Modifying AuditServiceProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuditServiceProvider configuration up to date.";

  Property.removeProperties(objid, 'properties',"AuditServiceProvider");

  Util.unsetAttribute(objid, "auditSpecifications", "AuditServiceProvider");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 1):
        continue;
      if currole == "WebSphereAuditSpecificationRef":
        AuditSpecificationRef.create(objid, curjsonobject, "auditSpecifications");

  Util.popPathElement('AuditServiceProvider');
