from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CellRoute')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCellRoute");
  exportedObject.put("roleName", "WebSphereCellRoute");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.cellroute.peeraccesspointname", objid, "peerAccessPointName","CellRoute");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CellRoute');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CellRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("CellRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "peerAccessPointName", roleProperties.optString("websphere.cellroute.peeraccesspointname", None));
  print "Creating CellRoute with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CellRoute", parentid, properties);
  Util.popPathElement('CellRoute');

def update(objid,jsonobject):
  Util.pushPathElement('CellRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("CellRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.cellroute.peeraccesspointname", None), "peerAccessPointName","CellRoute");
  if len(atts) != 0:
    print "Modifying CellRoute with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CellRoute configuration up to date.";

  Util.popPathElement('CellRoute');
