from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from KeyStoreRef import KeyStoreRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Certificate')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCertificate");
  exportedObject.put("roleName", "WebSphereCertificate");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.certificate.alias", objid, "alias","Certificate");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  keyStore = Util.getOptionalAttribute(objid, 'keyStore', 'Certificate');
  if keyStore is not None and len(keyStore) > 0:
    returndict = Util.createTypeFolder(respath, "KeyStoreRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, KeyStoreRef._export(keyStore, currespath, "KeyStore"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Certificate');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Certificate')
  if not jsonobject.has("roleProperties"):
    raise Exception("Certificate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.certificate.alias", None));
  print "Creating Certificate with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Certificate", parentid, properties);

  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereKeyStoreRef":
        KeyStoreRef.create(objid, currjsonobject, "keyStore");
  Util.popPathElement('Certificate');

def update(objid,jsonobject):
  Util.pushPathElement('Certificate')
  if not jsonobject.has("roleProperties"):
    raise Exception("Certificate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.certificate.alias", None), "alias","Certificate");
  if len(atts) != 0:
    print "Modifying Certificate with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Certificate configuration up to date.";

  Util.unsetAttribute(objid, "keyStore", "Certificate");

  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereKeyStoreRef":
        KeyStoreRef.create(objid, currjsonobject, "keyStore");
  Util.popPathElement('Certificate');
        
def find(parentid, jsonobject):

  if not jsonobject.has("roleProperties"):
    raise Exception("Certificate resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.certificate.alias'):
    raise Exception("Certificate resource has no property named websphere.certificate.alias!");

  alias = roleProperties.getString('websphere.certificate.alias');
  keyStoreName = None;
  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereKeyStoreRef":
        curroleProperties = currjsonobject.getJSONObject("roleProperties");
        if not curroleProperties.has('websphere.keystoreref.name'):
          raise Exception("KeyStore referenced by this Certificate resource has no property named websphere.keystoreref.name!");
        keyStoreName = curroleProperties.getString('websphere.keystoreref.name');
  
  certificateId = None;
  certificates = Util.getid("/Certificate:/").splitlines();
  if len(certificates) > 0:
    for certificate in certificates:
      if len(certificate) > 0:
        certificateAlias = Util.getRequiredAttribute(certificate, "alias", "Certificate" );
        certificateKeyStoreName = None;
        keyStore = Util.getOptionalAttribute(certificate, 'keyStore', 'Certificate');
        if keyStore is not None and len(keyStore) > 0:
          certificateKeyStoreName = Util.getOptionalAttribute(keyStore, 'name', 'KeyStore');

        if (alias == certificateAlias and keyStoreName == certificateKeyStoreName):
          certificateId = certificate;
          break;
  
  if certificateId is None or len(certificateId) < 1:
    raise Exception("Could not find certificate named %(alias)s with keystore name of %(name)s" % { 'alias':alias, 'name':keyStoreName } );

  return certificateId;
        
