from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.gridclassrules.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'GridClassRules');

  containmentpath = "%(parentconpath)sGridClassRules:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('GridClassRules')

  name = Util.getRequiredAttribute(objid, "name", 'GridClassRules');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGridClassRules");
  exportedObject.put("roleName", "WebSphereGridClassRules");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridclassrules.name", objid, "name","GridClassRules");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridclassrules.type", objid, "type","GridClassRules");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridclassrules.description", objid, "description","GridClassRules");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gridclassrules.matchaction", objid, "matchAction","GridClassRules");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GridClassRules');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("GridClassRules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.gridclassrules.name"):
    raise Exception("Resource role properties does not contain websphere.gridclassrules.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create GridClassRules on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('GridClassRules')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridClassRules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.gridclassrules.name"):
    raise Exception("Resource role properties does not contain websphere.gridclassrules.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.gridclassrules.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.gridclassrules.type", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.gridclassrules.description", None));
  Util.addIfNotNone(properties, "matchAction", roleProperties.optString("websphere.gridclassrules.matchaction", None));
  print "Creating GridClassRules with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GridClassRules", parentid, properties);
  Util.popPathElement('GridClassRules');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('GridClassRules')
  if not jsonobject.has("roleProperties"):
    raise Exception("GridClassRules resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.gridclassrules.name"):
    raise Exception("Resource role properties does not contain websphere.gridclassrules.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridclassrules.name", None), "name","GridClassRules");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridclassrules.type", None), "type","GridClassRules");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridclassrules.description", None), "description","GridClassRules");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gridclassrules.matchaction", None), "matchAction","GridClassRules");
  if len(atts) != 0:
    print "Modifying GridClassRules with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GridClassRules configuration up to date.";

  Util.popPathElement('GridClassRules');
