from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.httprequestheaderactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPRequestHeaderActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "HTTPRequestHeaderAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered HTTPRequestHeaderActionRef");
  exportedObject.put("roleName", "WebSphereHTTPRequestHeaderActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httprequestheaderactionref.name", objid, "name","HTTPRequestHeaderAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPRequestHeaderActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPRequestHeaderActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.httprequestheaderactionref.name"):
    raise Exception("Resource role properties does not contain websphere.httprequestheaderactionref.name!");

  httpRequestHeaderActionRefName = roleProperties.optString("websphere.httprequestheaderactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/HTTPRequestHeaderAction:" + httpRequestHeaderActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/HTTPRequestHeaderAction:" + httpRequestHeaderActionRefName + "/";
  httpRequestHeaderAction = Util.getid(containmentPath);
  if httpRequestHeaderAction == None or len(httpRequestHeaderAction) == 0:
      raise Exception("Could not determine the HTTP Request Header Action for HTTPRequestHeaderActionRef " + httpRequestHeaderActionRefName + ". Searched on containment path " + containmentPath + ".");

  #This really sucks... to support partial configurations, we need to tell Util where this object we are actually modifiying lives in the tree.
  #since it is a ref, we are really modifying the parent, which must have a path of Server/ProxyVirtualHostConfig/ProxyRuleExpression(just following the import chain)
  #since we are invoking the import directly from the importobject without there being any path elements, we will afterwards need to clean them up
  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', httpRequestHeaderAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
