#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from MessageAdapter import MessageAdapter

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('InboundResourceAdapter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInboundResourceAdapter");
  exportedObject.put("roleName", "WebSphereInboundResourceAdapter");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  msgAdapter = Util.getOptionalAttribute(objid, 'messageAdapter', 'InboundResourceAdapter');
  if msgAdapter is not None and len(msgAdapter) > 0:
    returndict = Util.createTypeFolder(respath, "MessageAdapter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, MessageAdapter._export(msgAdapter, currespath, "Message Adapter"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('InboundResourceAdapter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('InboundResourceAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("InboundResourceAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating InboundResourceAdapter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("InboundResourceAdapter", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereMessageAdapter":
        MessageAdapter.create(objid, curjsonobject);
  Util.popPathElement('InboundResourceAdapter');

def update(objid,jsonobject):
  Util.pushPathElement('InboundResourceAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("InboundResourceAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying InboundResourceAdapter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "InboundResourceAdapter configuration up to date.";

  msgAdapter = Util.getOptionalAttribute(objid, 'messageAdapter', 'InboundResourceAdapter');
  if msgAdapter is not None and len(msgAdapter) > 0:
    Util.remove(msgAdapter);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereMessageAdapter":
        MessageAdapter.create(objid, curjsonobject);
  Util.popPathElement('InboundResourceAdapter');
