from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ProxyOverrides')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxyOverrides");
  exportedObject.put("roleName", "WebSphereProxyOverrides");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.cacheupdateuri", objid, "cacheUpdateUri","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.outboundsslalias", objid, "outboundSSLAlias","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.connectionpoolenable", objid, "connectionPoolEnable","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.cacheinstancename", objid, "cacheInstanceName","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.sslcacheenable", objid, "sslCacheEnable","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.maxconnectionsperserver", objid, "maxConnectionsPerServer","ProxyOverrides");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxyoverrides.enablecaching", objid, "enableCaching","ProxyOverrides");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ProxyOverrides");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ProxyOverrides');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ProxyOverrides')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyOverrides resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cacheUpdateUri", roleProperties.optString("websphere.proxyoverrides.cacheupdateuri", None));
  Util.addIfNotNone(properties, "outboundSSLAlias", roleProperties.optString("websphere.proxyoverrides.outboundsslalias", None));
  Util.addIfNotNone(properties, "connectionPoolEnable", roleProperties.optString("websphere.proxyoverrides.connectionpoolenable", None));
  Util.addIfNotNone(properties, "cacheInstanceName", roleProperties.optString("websphere.proxyoverrides.cacheinstancename", None));
  Util.addIfNotNone(properties, "sslCacheEnable", roleProperties.optString("websphere.proxyoverrides.sslcacheenable", None));
  Util.addIfNotNone(properties, "maxConnectionsPerServer", roleProperties.optString("websphere.proxyoverrides.maxconnectionsperserver", None));
  Util.addIfNotNone(properties, "enableCaching", roleProperties.optString("websphere.proxyoverrides.enablecaching", None));
  print "Creating ProxyOverrides with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ProxyOverrides", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyOverrides');

def update(objid,jsonobject):
  Util.pushPathElement('ProxyOverrides')
  if not jsonobject.has("roleProperties"):
    raise Exception("ProxyOverrides resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.cacheupdateuri", None), "cacheUpdateUri","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.outboundsslalias", None), "outboundSSLAlias","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.connectionpoolenable", None), "connectionPoolEnable","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.cacheinstancename", None), "cacheInstanceName","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.sslcacheenable", None), "sslCacheEnable","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.maxconnectionsperserver", None), "maxConnectionsPerServer","ProxyOverrides");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxyoverrides.enablecaching", None), "enableCaching","ProxyOverrides");
  if len(atts) != 0:
    print "Modifying ProxyOverrides with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ProxyOverrides configuration up to date.";

  Property.removeProperties(objid, 'properties',"ProxyOverrides");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ProxyOverrides');
