from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ServiceLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServiceLog");
  exportedObject.put("roleName", "WebSphereServiceLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servicelog.name", objid, "name","ServiceLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servicelog.enabled", objid, "enabled","ServiceLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.servicelog.size", objid, "size","ServiceLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServiceLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ServiceLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.servicelog.name", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.servicelog.enabled", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.servicelog.size", None));
  print "Creating ServiceLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServiceLog", parentid, properties);
  Util.popPathElement('ServiceLog');

def update(objid,jsonobject):
  Util.pushPathElement('ServiceLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servicelog.name", None), "name","ServiceLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servicelog.enabled", None), "enabled","ServiceLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.servicelog.size", None), "size","ServiceLog");
  if len(atts) != 0:
    print "Modifying ServiceLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServiceLog configuration up to date.";

  Util.popPathElement('ServiceLog');
