from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.workclass.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'WorkClass');

  containmentpath = "%(parentconpath)sWorkClass:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('WorkClass')

  name = Util.getRequiredAttribute(objid, "name", 'WorkClass');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkClass");
  exportedObject.put("roleName", "WebSphereWorkClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclass.name", objid, "name","WorkClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclass.type", objid, "type","WorkClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclass.description", objid, "description","WorkClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workclass.matchaction", objid, "matchAction","WorkClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkClass');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.workclass.name"):
    raise Exception("Resource role properties does not contain websphere.workclass.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create WorkClass on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workclass.name"):
    raise Exception("Resource role properties does not contain websphere.workclass.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workclass.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.workclass.type", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.workclass.description", None));
  Util.addIfNotNone(properties, "matchAction", roleProperties.optString("websphere.workclass.matchaction", None));
  print "Creating WorkClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkClass", parentid, properties);
  Util.popPathElement('WorkClass');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('WorkClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.workclass.name"):
    raise Exception("Resource role properties does not contain websphere.workclass.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclass.name", None), "name","WorkClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclass.type", None), "type","WorkClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclass.description", None), "description","WorkClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workclass.matchaction", None), "matchAction","WorkClass");
  if len(atts) != 0:
    print "Modifying WorkClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkClass configuration up to date.";

  Util.popPathElement('WorkClass');
