from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from CustomAdvisor import CustomAdvisor
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomAdvisorPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomAdvisorPolicy");
  exportedObject.put("roleName", "WebSphereCustomAdvisorPolicy");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  customAdvisors = Util.parseConfigIdListAttribute(objid, 'customAdvisors',"CustomAdvisorPolicy");
  for customAdvisor in customAdvisors:
    if len(customAdvisor) > 0:
      returndict = Util.createTypeFolder(respath, "CustomAdvisor", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CustomAdvisor._export(customAdvisor, currespath, "Custom Advisor%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomAdvisorPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomAdvisorPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomAdvisorPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating CustomAdvisorPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomAdvisorPolicy", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCustomAdvisor":
        CustomAdvisor.create(objid, curjsonobject);
  Util.popPathElement('CustomAdvisorPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('CustomAdvisorPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomAdvisorPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying CustomAdvisorPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomAdvisorPolicy configuration up to date.";

  customAdvisors = Util.parseConfigIdListAttribute(objid, 'customAdvisors',"CustomAdvisorPolicy");
  for customAdvisor in customAdvisors:
    if len(customAdvisor) > 0:
      Util.remove(customAdvisor);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereCustomAdvisor":
        CustomAdvisor.create(objid, curjsonobject);

  Util.popPathElement('CustomAdvisorPolicy');
