from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('KeyReference')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereKeyReference");
  exportedObject.put("roleName", "WebSphereKeyReference");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keyreference.version", objid, "version","KeyReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keyreference.password", objid, "password","KeyReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keyreference.keyalias", objid, "keyAlias","KeyReference");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('KeyReference');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('KeyReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "version", roleProperties.optString("websphere.keyreference.version", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.keyreference.password", None));
  Util.addIfNotNone(properties, "keyAlias", roleProperties.optString("websphere.keyreference.keyalias", None));
  print "Creating KeyReference with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("KeyReference", parentid, properties);
  Util.popPathElement('KeyReference');

def update(objid,jsonobject):
  Util.pushPathElement('KeyReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keyreference.version", None), "version","KeyReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keyreference.password", None), "password","KeyReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keyreference.keyalias", None), "keyAlias","KeyReference");
  if len(atts) != 0:
    print "Modifying KeyReference with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "KeyReference configuration up to date.";

  Util.popPathElement('KeyReference');
