#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(parentrespath, host, port):
  Util.pushPathElement('LDAPFailoverServer')

  name = host + ":" + port;
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLDAPFailoverServer");
  exportedObject.put("roleName", "WebSphereLDAPFailoverServer");

  roleProperties = JSONObject();

  Util.addToJsonIfNotNone(roleProperties, "host", host);
  Util.addToJsonIfNotNone(roleProperties, "port", port);

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LDAPFailoverServer');
  return result;

def create(jsonobject, repo, primary_host):
  Util.pushPathElement('LDAPFailoverServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("LDAPFailoverServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  host = roleProperties.optString("host", None);
  addIdMgrLDAPBackupServerParams = '[-id "' + repo + '" -primary_host ' + primary_host + ' -host ' + host;
  port = roleProperties.optString("port", None);
  if port != None and port != "null" and len(port) > 0:
    addIdMgrLDAPBackupServerParams = addIdMgrLDAPBackupServerParams + " -port " + port + "]";
  else:
    addIdMgrLDAPBackupServerParams = addIdMgrLDAPBackupServerParams + "]";
  Log.debug("Running command to add failover LDAP server: AdminTask.addIdMgrLDAPBackupServer(" + addIdMgrLDAPBackupServerParams + ")");
  Util.addIdMgrLDAPBackupServer(addIdMgrLDAPBackupServerParams);
  Util.popPathElement('LDAPFailoverServer');

def remove(repo, primary_host, failoverHost, failoverPort):
  removeIdMgrLDAPBackupServerParams = '[-id "' + repo + '" -primary_host ' + primary_host + ' -host ' + failoverHost;
  if len(failoverPort) > 0:
    removeIdMgrLDAPBackupServerParams = removeIdMgrLDAPBackupServerParams + " -port " + failoverPort + "]";
  else:
    removeIdMgrLDAPBackupServerParams = removeIdMgrLDAPBackupServerParams + "]";
  Log.debug("Running command to remove LDAP failover server: AdminTask.removeIdMgrLDAPBackupServer(" + removeIdMgrLDAPBackupServerParams + ")");
  Util.removeIdMgrLDAPBackupServer(removeIdMgrLDAPBackupServerParams);

